clear all

load row
load validx
load validy
load i

%%%

% The first points have to set on the marker!

%%%% Processing

NumberOfPoints = row;

%%% Scaling in pixel per m (FIJI -> Analyze -> Set Scale)
space_scaling = 5.1288; %Nachmessen!

%%% Scaling in time between images (FIJI -> Image -> Show Info -> Bottom -> Frame Intervall)
time_scaling = 59.746;

PointsPerTrack = NumberOfPoints/5;

% X und Y Werte ine ein File schreiben
k=1;
for j=1:1:NumberOfPoints
    results(k,:) = validx(j,:);
    results(k+1,:) = validy(j,:);
    k=k+2;
end

% Verschiebung

for j=1:1:NumberOfPoints
displacement_x(j,1) = 0;
displacement_y(j,1) = 0;
for g=2:1:i
    displacement_x(j,g) = validx(j,g)-validx(j,g-1);
    displacement_y(j,g) = validy(j,g)-validy(j,g-1);
end
end
    

% Add up all displacements
% sum_displacement_x(1)=0;
% sum_displacement_y(1)=0;
% for g=2:1:i
%     sum_displacement_x(g) = sum_displacement_x(g-1)+mean(displacement_x(1:PointsPerTrack,g));    
%     sum_displacement_y(g) = sum_displacement_y(g-1)+mean(displacement_y(1:PointsPerTrack,g));
% end

for g=1:1:i
    sum_displacement_x(g) = mean(validx(1:PointsPerTrack,g))-mean(validx(1:PointsPerTrack,1));
    sum_displacement_y(g) = mean(validy(1:PointsPerTrack,g))-mean(validy(1:PointsPerTrack,1));
end

%Define center point and correct for drift
center_x(1) = mean(validx(PointsPerTrack+1:NumberOfPoints,1));
center_y(1) = mean(validy(PointsPerTrack+1:NumberOfPoints,1));
for g=2:1:i
    center_x(g) = center_x(1)+sum_displacement_x(g);
    center_y(g) = center_y(1)+sum_displacement_y(g);
end

% Distanz bzw. Auslenkung vom Anfangsort ausrechnen
% Sign Calculation

% Calculate distance to center Point
for j=1:1:NumberOfPoints
    for h=1:1:i
        center_distance(j,h) = sqrt((validx(j,h)-center_x(h))^2+(validy(j,h)-center_y(h))^2);
    end
end

for j=1:1:NumberOfPoints
    sign(j,1)=1;
    for h=1:1:i
        if (center_distance(j,h)<center_distance(j,1))
            sign(j,h) = -1;
        else
            sign(j,h) = 1;
        end
    end
end

for j=1:1:NumberOfPoints
    for h=1:1:i
        distance(j,h) = (center_distance(j,h)-center_distance(j,1));
    end
    k=k+2;
end



PointsPerTrack = NumberOfPoints/5;
for j = 1:1:5
    for g=1:1:i
        distance_mean(j,g) = median(distance(j*PointsPerTrack-PointsPerTrack+1:j*PointsPerTrack,g));
    end
end


%%% Scale data

distance_mean = distance_mean/space_scaling;
distance = distance/space_scaling;

for t = 1:1:i
    time_points(t) = t*time_scaling/60;
end

%%% Plot


figure
hold on
xlabel("Time (minutes)")
ylabel("Displacement from center (m)")
box on
for j=1:1:5
    plot(time_points,distance_mean(j,:),'-x','LineWidth',1)
end
% axis([0 inf -0.5 2.5])
legend('Reference','Top', 'Right', 'Bottom', 'Left')
lgd=legend;
lgd.FontSize = 12;
lgd.NumColumns = 2;
hold off

print(gcf,'Image_Beams.png','-dpng','-r300');

figure
hold on
xlabel("Time (minutes)")
ylabel("Displacement from center (m)")
box on

plot(time_points,mean(distance_mean(2:5,:)),'-x','LineWidth',1)
    
% axis([0 inf -0.5 2.5])
legend('Average')
lgd=legend;
lgd.FontSize = 12;
lgd.NumColumns = 2;
hold off

print(gcf,'Image_Average.png','-dpng','-r300');

%%% Save

save workspace.mat